#include <assert.h>
#include <stdio.h>
#ifdef __PL_WINDOWS__
	#include <windows.h>
#endif // __PL_WINDOWS__
#if defined (__PL_LINUX__) || (__PL_SOLARIS__) || (__PL_MACOSX__) 
	#include <uuid/uuid.h>
#endif // __PL_LINUX__ || __PL_SOLARIS__ || __PL_MACOSX__
#include "productivity_link.h"

#define ITERATIONS 100
#define APPLICATION_NAME_STRING "producer"
#define COUNTER_STRINGS	{ 
	"performance", 
	NULL, 
	"work_units", 
	NULL, 
	NULL 
}
enum { 
	PERFORMANCE = 0,	
	UNNAMED_1, 
	WORK_UNITS, 
	UNNAMED_2, 
	UNNAMED_3 
};

int main(void) {

	int i = 0;
	int ret;
	uuid_t pl;
	int pld = PL_INVALID_DESCRIPTOR;
	const char *my_counters[MAX_COUNTERS] = COUNTER_STRINGS;

	unsigned long long performance = 0;
	unsigned long long work_units = 0;
	unsigned long long counter_1 = 0;
	unsigned long long counter_2 = 0;
	unsigned long long counter_3 = 0;

	pld = pl_open(
		APPLICATION_NAME_STRING, 
		MAX_COUNTERS, 
		my_counters, 
		&pl
	);
	assert(pld != PL_INVALID_DESCRIPTOR);


	for(i = 0; i < ITERATIONS; i++) {

		work_units++;
		performance++;
		counter_1++;
		counter_2++;
		counter_3++;

#ifdef __PL_WINDOWS__
		Sleep(PAUSE);
		printf("Iteration %d\twork units: %I64u\n", i, work_units);
#endif // __PL_WINDOWS__
#if defined (__PL_LINUX__) || defined (__PL_SOLARIS__) || (__PL_MACOSX__) 
		sleep(PAUSE);
		printf("Iteration %d\twork units: %llu\n", i, work_units);
#endif // __PL_LINUX__ || __PL_SOLARIS__ || __PL_MACOSX__

		ret = pl_write(pld, &performance, PERFORMANCE); 
		assert(ret == PL_SUCCESS);
		ret = pl_write(pld, &counter_1, UNNAMED_1); 
		assert(ret == PL_SUCCESS);
		ret = pl_write(pld, &work_units, WORK_UNITS); 
		assert(ret == PL_SUCCESS);
		ret = pl_write(pld, &counter_2, UNNAMED_2); 
		assert(ret == PL_SUCCESS);
		ret = pl_write(pld, &counter_3, UNNAMED_3); 
		assert(ret == PL_SUCCESS);
	}
	ret = pl_close(pld);
	assert(ret == PL_SUCCESS);
	return(0);
}
